/*
   ######################################################################

   XBlast Robot.inc

   Character design tutorial part 4

   (C) by Mark Weyer

   ######################################################################
*/

//
///
//// We have taken care of the states Standing and Walking.
//// There are some more:
//// - Winning: This is the state of the winner in a game (the last
////   player alive after everybody else has been killed). It also is the
////   state of the cheering crowd between games and after a match and
////   of the winner of a game or match that is cheered at by the crowd.
////   Variables:
////   playerWinning: the flag
////   playerAnimationClock: similar to playerWalkingClock. Its value
////     can be 0,1, or 2. The sequence is ...0,1,2,1,0,1,2,1,... .
////     for the non-animated winner of a match the value is 0.
////   playerWinningTime: similar to playerWalkingTime. Its value can be
////   0, 0.5, or 1.
//// - Losing: This is the state of the disappointed crowd between games.
////   It is also the state of the losers of a game at that occasion
////   and sometimes after the match.
////   The losers in the game are just skeletons.
////   Variables:
////   playerLosing: the flag
////   playerAnimationClock: the same as above, for the non-animated losers
////   of a match the value is 0.
////   playerLosingTime: similar to above.
//// - Killed: This is the state of a player that has just been hit by a
////   bomb but has not yet completely lost the game. It is only very
////   shortly visible at that occasion. It is also sometimes the state of
////   the losers after the match.
////   Variables:
////   playerKilled: the flag
///
//// We will now make suitable adjustments for all states
///
//

// colours

#local wheelColour1 = handsFeetColor;
#local wheelColour2 = armsLegsColor;
#local eyeColour = faceColor;

// basic constants

#declare Wheel_diam = 8/pi;
#declare Wheel_thickness = 1/2;
#declare Eye_size = 2/3;

//
///
//// This is new:
///
//

// derived constants for handling different states

#if (playerKilled)
  #local Wheel_raise = Wheel_thickness/2;
  #local Eye_raise = 3*Wheel_raise;
  #local Eye_down = 60;
#else
  #local Wheel_raise = Wheel_diam/2;
  #local Eye_raise = 2*Wheel_raise;
  #local Eye_down = 0;
#end

#if (playerLosing)
  #local Eye_down = 30;
  #local Eye_leftright = 30*cos(playerLosingTime*pi);
#else#if (playerWalking)
  #local Eye_leftright = 45*sin(playerWalkingTime*2*pi);
#else
  #local Eye_leftright = 0;
#end#end

#if (playerWinning)
  #local Eye_down = -10;
#end

// a macro for eyes

#macro eye(side)
  sphere {
    0 1/2
    pigment {	// this pigment partitions the eye into three layers:
		// black (pupil), eyeColour (iris), and white (rest)
      checker
      pigment {rgb <1,1,1>}
      pigment {
        checker
        pigment {rgb eyeColour}
        pigment {rgb <0,0,0>}
        translate <1/2,1/2,0>
        scale 10
        translate -z/4
      }
      translate <1/2,1/2,0>
      scale <10,10,1>
      translate -z/6
    }
    rotate Eye_leftright*y
    rotate -Eye_down*x
    scale Eye_size
    translate <side*2/3,Eye_raise,-1/2>
//
///
//// Previously these transformations had been:
///
//    #if (playerWalking)
//      rotate 45*sin(playerWalkingTime*2*pi)*y
//    #end
//    scale Eye_size
//    translate <side*2/3,Wheel_diam,-1/2>
  }
#end

#macro wheel()
  torus {
    (Wheel_diam-Wheel_thickness)/2 Wheel_thickness/2
    rotate 90*z
    pigment {	// this pigment partitions the wheel in four sectors
      checker
      pigment {rgb wheelColour1}
      pigment {rgb wheelColour2}
      translate x/2
      scale 10
    }
    #if (playerWalking)
      rotate -180*playerWalkingTime*x
    #end
//
///
//// In Killed state the wheel lies on the floor.
///
//
    #if (playerKilled)
      rotate 90*z
    #end
    translate Wheel_raise*y
//
///
//// Previously this translate had been:
///
//    translate Wheel_diam/2*y
  }
#end

union {
  wheel()
  eye(1)
  eye(-1)
//
///
//// In Winning state the character jumps.
///
//
  #if (playerWinning)
    translate (1-pow(playerWinningTime,2))*4/3*y
  #end

  rotate playerAngle*y
  translate playerLocation
  translate -2*z
}

//
///
//// That's all. The tutorial ends here.
///
//

